﻿// 模板规则
//   1. 用 "//<snippet>" 标记来标记代码段。第一处标记用于确定代码段的开头。
//      第二处标记用于确定结尾。建议(但不要求)添加 BEGIN 和
//      END 后缀，以便获得更佳的可读性，例如 "//<snippet> - BEGIN"，"//<snippet> - END"。
//      如果代码段只有一行，则可以省略第二个标记(例如，请参阅 ClrNamespaceFooter 标记)。
//
//   2. 代码段标记应该位于代码段上面(下面)单独的行上，或者位于第一个 
//      (最后一个)代码段行的末尾。从标记到行末尾的文本将被删除。
//
//   3. 以下区分大小写的字是保留字。它们将在示例数据代码生成过程中被数据存储数据名称(类型名称、
//      属性名称等)所替代。
//          CLR_NAMESPACE
//          GLOBALSTORAGE_TYPE
//          DATASTORE_TYPE
//          PROPERTY_NAME
//          PROPERTY_TYPE
//          PROPERTY_VALUE
//          PROJECT_ASSEMBLY_NAME
//          DATA_STORE_ROOT_FOLDER
//          DATA_STORE_NAME
//
//   4. 区分大小写的代码段标记为
//          ClrNamespaceHeader
//          ClrNamespaceFooter
//          GlobalStorageTypeHeader
//          GlobalStorageTypeFooter
//          GlobalStorageGetSetProperty
//          DataStoreTypeHeader
//          DataStoreTypeFooter
//          DataStoreTypeConstructor
//          DataStoreGetSetProperty
///////////////////////////////////////////////////
namespace CLR_NAMESPACE //ClrNamespaceHeader - BEGIN
{
	using System;
	using System.Collections.Generic; //ClrNamespaceHeader - END
	
	public class GLOBALSTORAGE_TYPE //GlobalStorageTypeHeader - BEGIN
	{
		public static GLOBALSTORAGE_TYPE Singleton;
		public bool Loading {get;set;}
		private List<WeakReference> registrar; 

		public GLOBALSTORAGE_TYPE()
		{
			this.registrar = new List<WeakReference>();
		}
		
		static GLOBALSTORAGE_TYPE()
		{
			Singleton = new GLOBALSTORAGE_TYPE();
		}

		public void Register(DATASTORE_TYPE dataStore)
		{
			this.registrar.Add(new WeakReference(dataStore));
		}

		public void OnPropertyChanged(string property)
		{
			foreach (WeakReference entry in this.registrar)
			{
				if (!entry.IsAlive)
				{
					continue;
				}
				DATASTORE_TYPE dataStore = (DATASTORE_TYPE)entry.Target;
				dataStore.FirePropertyChanged(property);
			}
		}
		
		public bool AssignementAllowed
		{
			get
			{
				// 加载后仅分配一次
				if(this.Loading && this.registrar.Count > 0)
				{
					return false;
				}
				
				return true;
			}
		}

		//GlobalStorageTypeHeader - END

		//在下面列出属性 
		private PROPERTY_TYPE _PROPERTY_NAME = PROPERTY_VALUE;  //GlobalStorageGetSetProperty - BEGIN

		public PROPERTY_TYPE PROPERTY_NAME
		{
			get
			{
				return this._PROPERTY_NAME;
			}

			set
			{
				if(!this.AssignementAllowed)
				{
					return;
				}
				
				if (this._PROPERTY_NAME != value)
				{
					this._PROPERTY_NAME = value;
					this.OnPropertyChanged("PROPERTY_NAME");
				}
			}
		}  //GlobalStorageGetSetProperty - END
		
	} //GlobalStorageTypeFooter

	public class DATASTORE_TYPE : System.ComponentModel.INotifyPropertyChanged //DataStoreTypeHeader - BEGIN
	{
		public event System.ComponentModel.PropertyChangedEventHandler PropertyChanged;
		
		public void FirePropertyChanged(string propertyName)
		{
			this.OnPropertyChanged(propertyName);
		}

		protected virtual void OnPropertyChanged(string propertyName)
		{
			if (this.PropertyChanged != null)
			{
				this.PropertyChanged(this, new System.ComponentModel.PropertyChangedEventArgs(propertyName));
			}
		} //DataStoreTypeHeader - END

		public DATASTORE_TYPE() //DataStoreTypeConstructor - BEGIN
		{
			try
			{
				System.Uri resourceUri = new System.Uri("/PROJECT_ASSEMBLY_NAME;component/DATA_STORE_ROOT_FOLDER/DATA_STORE_NAME/DATA_STORE_NAME.xaml", System.UriKind.Relative);
				if (System.Windows.Application.GetResourceStream(resourceUri) != null)
				{
					GLOBALSTORAGE_TYPE.Singleton.Loading = true;
					System.Windows.Application.LoadComponent(this, resourceUri);
					GLOBALSTORAGE_TYPE.Singleton.Loading = false;
					GLOBALSTORAGE_TYPE.Singleton.Register(this);
				}
			}
			catch (System.Exception)
			{
			}
		} //DataStoreTypeConstructor - END

		private PROPERTY_TYPE _PROPERTY_NAME = PROPERTY_VALUE;  //DataStoreGetSetProperty - BEGIN

		public PROPERTY_TYPE PROPERTY_NAME
		{
			get
			{
				return GLOBALSTORAGE_TYPE.Singleton.PROPERTY_NAME;
			}

			set
			{
				GLOBALSTORAGE_TYPE.Singleton.PROPERTY_NAME = value;
			}
		}  //DataStoreGetSetProperty - END

	} //DataStoreTypeFooter
} //ClrNamespaceFooter
